
## Script: Banner Clicker
## Version: 1.06 (TCL)
## Release Date: October 4th, 1999
## Author(s): twidge & FeDude
## Updater: VGrep Network, Inc.
## Requirements: Eggdrop 1.3.x


## INTRODUCTION:
##
##	Banner Clicker is a mIRC/TCL script allowing you to generate
##	false hits at your banner provider or toplist. The result of
##	Banner Clicker is that the script "visits" your web page and
##	"clicks" on your banner. What the script actually does however
##	is different.

##	It opens a connection to your banner provider's web page and
##	requests your banner's image. While requesting this, it tells
##	the provider that it was referred by your web page. It then
##	closes that connection and pauses 10 seconds. This is to give
##	the feeling that you just loaded the page and didn't notice
##	the banner yet. After 10 seconds it opens up a new connection
##	to the banner provider requesting the link that clicking on the
##	banner brings you to. Again, it tells the banner provider that
##	it came from the web page you signed up for, and not using a
##	trick method like a hidden frame, etc. The banner provider then
##	thinks you actually went to your homepage and clicked your
##	banner.

##	It will only allow 100 clicks per person per day to prevent
##	greedy people from tearing up the resources.

##	Banner Clicker will automatically send click requests for your
##	banners. It sends a "!click" request whenever it joins the
##	channel, and a "!click2" request to everyone else who joins.
##	You need to set your click commands in the settings section
##	below.

##	More information is avaliable in the readme file to the mIRC
##	version of BC (BCReadme.txt).

##	To view the activity of your bot, type:
##	".console +5"


## SETTINGS:
##
##	Note: Each setting are already pre-configured for normal use.
##	If you do not have any experience with TCL, you may proceed
##	directly to the click requests part at the buttom of the
##	settings section.

##	You don't need to add the banner channels to the bot yourself.
##	The script will add them automatically with the appropriate
##	settings. Set the name of the banner clicking channel and chat
##	channel below.

set bc_chans "#Banner"
set bc_chatchan "#BannerChat"

##	If you do not want the script to add the channels itself (i.e.
##	if the bot already has the banner channels added), then set
##	this to 0.

set bc_addchans 1

##	Maximum click requests per day. On a professional and high
##	traffic site, you may let the script keep requesting the entire
##	time. On a slow traffic site, all the clicks generated will
##	expose you as a cheat, and your payment will be cancled. You
##	must limit the number of click requests the bot sends per day,
##	and try to maintain your "click through ratio" nice and low
##	(under 7%). Start with 100 click requests per day and adjust
##	after a few days observing your click stats. Remember, the
##	click requests don not always equal the number of clicks you
##	actually get (100 click requests per day may get you, say 20
##	clicks one day, 50 the next, 35 the next day, and so on).

set bc_maxreq 1000

##	If the banners are standard banners (non image maps), use the
##	following syntax:
##
##	set bc_banners(<name>) {
##	"<banner host> <image url 1> <click url 1> <referer url 1> [options]"
##	"<banner host> <image url 2> <click url 2> <referer url 2> [options]"
##	}
##
##	If the banners are using image maps, you have to use TCL
##	commands to generate random numbers. The following syntax must
##	be used:
##
##	set bc_banners(<name>) [list "<banner host> <image url 1> <click url 1>
##	<referer url 1> [options]" "<banner host> <image url 2> <click url 2>
##	<referer url 2> [options]"
##
##	The examples settings below should illustrate the the click
##	requests so an unexperienced BC user should understand. The
##	settings are the same as in version 1.04, allowing you to use
##	your old settings (if any).

  set bc_banners(Banner-I) {
    "www.sponsor.com /cgi-bin/image.cgi?username /cgi-bin/click.cgi?username http://www.yoursite.com unique"
  }
  set bc_banners(Banner-II) {
    "www.sponsor.com /cgi-bin/image.cgi?username /cgi-bin/click.cgi?username http://www.yoursite.com unique"
  }
  set bc_banners(Banner-III) {
    "www.sponsor.com /cgi-bin/image.cgi?username /cgi-bin/click.cgi?username http://www.yoursite.com unique"
  }
  set bc_banners(Map-Banner) [list "www.sponsor.com /cgi-bin/image.cgi?username /cgi-bin/click.cgi?[rand 400],[rand 60] http://www.youtsite.com"]


##	Please leave the area below untouched.
##	EOF.


proc bc_join {nick uhost handle channel} {
  global bc_banners bc_chans bc_cinterval bc_c2interval botnick
  if {[lsearch -exact [string tolower [split $bc_chans]] [string tolower $channel]] == -1} {return 0}
  set time [expr 100 + [rand 100]]
  if {$nick == $botnick} {
    foreach utimer [utimers] {
      if {[string match *bc_click* $utimer]} {
        killutimer [lindex $utimer 2]
      }
    }
    foreach banner [bc_random [array names bc_banners]] {
      utimer $time [split "bc_click $banner $channel"]
      set time [expr $time + $bc_cinterval]
    }
  } else {
    foreach banner [bc_random [array names bc_banners]] {
      utimer $time [split "bc_click2 $banner $channel $nick"]
      set time [expr $time + $bc_c2interval]
    }
  }
}

proc bc_click {banner channel} {
  global bc_banners bc_clickreqs bc_maxreq botnick
  if {![onchan $botnick $channel]} {return 0}
  if {$bc_clickreqs >= $bc_maxreq} {return 0}
  puthelp "PRIVMSG $channel :!click [subst [lindex $bc_banners($banner) [rand [llength $bc_banners($banner)]]]]"
  incr bc_clickreqs 10
  putloglev 5 * "BC: % requested $channel to click $banner banner (request $bc_clickreqs of $bc_maxreq)."
}

proc bc_click2 {banner channel nick} {
  global bc_banners bc_clickreqs bc_maxreq botnick
  if {![onchan $botnick $channel] || ![onchan $nick $channel]} {return 0}
  if {$bc_clickreqs >= $bc_maxreq} {return 0}
  puthelp "PRIVMSG $channel :!click2 $nick [subst [lindex $bc_banners($banner) [rand [llength $bc_banners($banner)]]]]"
  incr bc_clickreqs
  putloglev 5 * "BC: % requested $nick on $channel to click $banner banner (request $bc_clickreqs of $bc_maxreq)."
}

proc bc_addclick {nick uhost handle channel arg} {
  global bc_chans bc_count bc_qmax bc_queue bc_quota bc_unique
  if {[lsearch -exact [string tolower [split $bc_chans]] [string tolower $channel]] == -1} {return 0}
  if {![info exists bc_count($uhost)]} {
    set bc_count($uhost) 0
  } elseif {$bc_count($uhost) >= $bc_quota} {
    putloglev 5 * "BC: @ skipping request from $nick (quota reached)."
    puthelp "NOTICE $nick :BC: Your request quota has been reached ($bc_quota/day)."
    return 0
  }
  if {[llength $bc_queue] >= $bc_qmax} {
    putloglev 5 * "BC: @ skipping request from $nick (queue is full)."
    puthelp "NOTICE $nick :BC: Request queue is full. Please try again later."
    return 0
  } elseif {[string match "*$nick*" $bc_queue]} {
    putloglev 5 * "BC: @ skipping request from $nick (item already in queue)."
    puthelp "NOTICE $nick :BC: You already have a request in queue."
    return 0
  } elseif {[string match "http://*" [sindex $arg 0]] || [sindex $arg 3] == ""} {
    putloglev 5 * "BC: @ skipping request from $nick (invalid request)."
    puthelp "NOTICE $nick :BC: Invalid request."
    return 0
  }
  incr bc_count($uhost)
  set bhost [sindex $arg 0]
  set image [sindex $arg 1]
  set link [sindex $arg 2]
  set referer [sindex $arg 3]
  set options [join [lrange [split $arg] 4 end]]
  if {[string match *post* [string tolower $options]]} {return 0}
  if {[string match *unique* [string tolower $options]]} {
    if {[lsearch -exact $bc_unique "$bhost $image $link"] != -1} {
      putloglev 5 * "BC: @ skipping request from $nick (unique request already processed)."
      puthelp "NOTICE $nick :BC: Your click request has already been processed using this IP."
      return 0
    } else {
      lappend bc_unique "$bhost $image $link"
    }
  }
  lappend bc_queue "$nick $bhost $image $link $referer"
  set queue [llength $bc_queue]
  putloglev 5 * "BC: @ added request ($bc_count($uhost)/$bc_quota) from $nick to queue ($queue/$bc_qmax)."
  puthelp "NOTICE $nick :BC: Request added to queue ($queue/$bc_qmax)."
}

proc bc_addclick2 {nick uhost handle channel arg} {
  global botnick
  if {[string tolower [sindex $arg 0]] == [string tolower $botnick]} {
    bc_addclick $nick $uhost $handle $channel [join [lrange [split $arg] 1 end]]
  }
}

proc bc_doload {} {
  global bc_agent bc_browsers bc_busy bc_queue
  if {$bc_busy} {return 0}
  if {[llength $bc_queue] == 0} {
    utimer 10 bc_doload
    return 0
  }
  set bc_busy 1
  set item [lindex $bc_queue 0]
  set bc_queue [lrange $bc_queue 1 end]
  set nick [sindex $item 0]
  set bhost [sindex $item 1]
  set image [sindex $item 2]
  set link [sindex $item 3]
  set referer [sindex $item 4]
  set browser [lindex $bc_browsers [rand [llength $bc_browsers]]]
  set agent [rand [llength $bc_agent($browser)]]
  if {[catch {set http [socket $bhost 80]}] == 1} {
    putloglev 5 * "BC: * unable to connect to $nick's request ($bhost)."
    puthelp "NOTICE $nick :BC: Unable to connect to $bhost."
    utimer 1 bc_doload
    set bc_busy 0
    return 0
  }
  switch -exact -- $browser {
    msie {
      puts $http "GET $image HTTP/1.1"
      puts $http "Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*"
      puts $http "Referer: $referer"
      puts $http "Accept-Language: en-us"
      puts $http "Accept-Encoding: gzip, deflate"
      puts $http "User-Agent: [lindex $bc_agent($browser) $agent]"
      puts $http "Host: $bhost"
      puts $http "Connection: Keep-Alive"
      puts $http ""
    }
    ns {
      puts $http "GET $image HTTP/1.0"
      puts $http "Referer: $referer"
      puts $http "Connection: Keep-Alive"
      puts $http "User-Agent: [lindex $bc_agent($browser) $agent]"
      puts $http "Host: $bhost"
      puts $http "Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, image/png, */*"
      puts $http "Accept-Encoding: gzip"
      puts $http "Accept-Language: en"
      puts $http "Accept-Charset: iso-8859-1,*,utf-8"
      puts $http ""
    }
  }
  if {![set ctmr [rand 5]]} {
    close $http
  } else {
    utimer $ctmr [split "close $http"]
  }
  set wait [expr 5 + [rand 21]]
  putloglev 5 * "BC: * loaded $nick's banner ($bhost). Sleeping $wait seconds..."
  utimer $wait [split "bc_doclick $nick $browser $agent $bhost $link $referer"]
}

proc bc_doclick {nick browser agent bhost link referer} {
  global bc_agent bc_browsers bc_busy
  if {[catch {set http [socket $bhost 80]}] == 1} {
    putloglev 5 * "BC: * unable to connect to $nick's request ($bhost)."
    puthelp "NOTICE $nick :BC: Unable to connect to $bhost."
    utimer 1 bc_doload
    set bc_busy 0
    return 0
  }
  switch -exact -- $browser {
    msie {
      puts $http "GET $link HTTP/1.1"
      puts $http "Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*"
      puts $http "Referer: $referer"
      puts $http "Accept-Language: en-us"
      puts $http "Accept-Encoding: gzip, deflate"
      puts $http "User-Agent: [lindex $bc_agent($browser) $agent]"
      puts $http "Host: $bhost"
      puts $http "Connection: Keep-Alive"
      puts $http ""
    }
    ns {
      puts $http "GET $link HTTP/1.0"
      puts $http "Referer: $referer"
      puts $http "Connection: Keep-Alive"
      puts $http "User-Agent: [lindex $bc_agent($browser) $agent]"
      puts $http "Host: $bhost"
      puts $http "Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, image/png, */*"
      puts $http "Accept-Encoding: gzip"
      puts $http "Accept-Language: en"
      puts $http "Accept-Charset: iso-8859-1,*,utf-8"
      puts $http ""
    }
  }
  putloglev 5 * "BC: * processed $nick's request ($bhost)."
  puthelp "NOTICE $nick :BC: Your request ($bhost) has been processed."
  if {![set ctmr [rand 3]]} {
    close $http
    set bc_busy 0
  } else {
    utimer $ctmr [split "close $http"]
    utimer $ctmr "set bc_busy 0"
  }
  utimer 3 bc_doload
}

proc bc_chkchans {min hour day month year} {
  global bc_chans bc_chatchan botnick
  if {[onchan $botnick $bc_chatchan] && ![isvoice $botnick $bc_chatchan]} {
    putloglev 5 * "BC: Not voice (+v) on $bc_chatchan. Cycling..."
    putserv "PART $bc_chatchan"
  } else {
    foreach channel [split $bc_chans] {
      if {![onchan $botnick $channel] && [onchan $botnick $bc_chatchan]} {
        putloglev 5 * "BC: Requesting invite to $channel."
        puthelp "PRIVMSG $bc_chatchan :!invite"
      } elseif {[onchan $botnick $channel] && ![isvoice $botnick $channel]} {
        putloglev 5 * "BC: Not voice (+v) on $channel. Cycling..."
        putserv "PART $channel"
        utimer 30 "bc_chkchans * * * * *"
      }
    }
  }
}

proc bc_random {list} {
  set randlist ""
  while {[llength $list] > 0} {
    set random [rand [llength $list]]
    lappend randlist [lindex $list $random]
    set list [lreplace $list $random $random]
  }
  return $randlist
}

proc bc_reset {min hour day month year} {
  global bc_count bc_unique bc_clickreqs
  unset bc_count
  set bc_unique ""
  set bc_clickreqs 0
}

proc bc_kickstart {min hour day month year} {
  global bc_busy bc_qmax bc_queue
  if {[llength $bc_queue] >= $bc_qmax && $bc_busy && ![string match *bc_doclick* [utimers]] && ![string match *bc_doload* [utimers]]} {
    putloglev 5 * "BC: Clicking process halted. Kick starting..."
    set bc_busy 0
    utimer 10 bc_doload
  }
}

proc bc_ctcp {nick uhost handle dest keyword arg} {
  global bc_ver
  putserv "NOTICE $nick :Running BC TCL $bc_ver"
}

proc sindex {arg n} {
  return [lindex [split $arg] $n]
}

if {![info exists bc_busy]} {
  set bc_busy 0
}
if {![info exists bc_queue]} {
  set bc_queue ""
}
if {![info exists bc_unique]} {
  set bc_unique ""
}
if {![info exists bc_clickreqs]} {
  set bc_clickreqs 0
}

set bc_qmax 30
set bc_quota 40
set bc_cinterval 1200
set bc_c2interval 180

set bc_browsers {
  "msie"
  "ns"
}

set bc_agent(msie) {
  "Mozilla/2.0 (compatible; MSIE 3.0B; Win32)"
  "Mozilla/4.0 (compatible; MSIE 4.0; Windows 95)"
  "Mozilla/4.0 (compatible; MSIE 4.01; Windows 98)"
  "Mozilla/4.0 (compatible; MSIE 4.01; Windows NT)"
  "Mozilla/4.0 (compatible; MSIE 5.0b2; Windows 98)"
  "Mozilla/4.0 (compatible; MSIE 5.0; Windows 98)"
  "Mozilla/4.0 (compatible; MSIE 5.0; Windows 98; DigExt)"
  "Mozilla/4.0 (compatible; MSIE 5.0; Windows 98; TUCOWS)"
}

set bc_agent(ns) {
  "Mozilla/3.04 (Win95; I)"
  "Mozilla/4.04 [en] (WinNT; U)"
  "Mozilla/4.08 [en] (Win98; I ;Nav)"
  "Mozilla/4.08 [en] (X11; I; Linux 2.0.36 i586)"
  "Mozilla/4.5 [en] (Win98; I)"
  "Mozilla/4.51 [en] (Win98; I)"
  "Mozilla/4.51 [en] (Win98; U)"
  "Mozilla/4.51 [en] (X11; I; Linux 2.2.5-4 i586)"
  "Mozilla/4.51 [en] (X11; I; Linux 2.2.7 i686)"
  "Mozilla/4.51 [en] (X11; I; Linux 2.2.8 i586)"
  "Mozilla/4.6 [en] (Win98; I)"
  "Mozilla/4.6 [en] (X11; I; Linux 2.2.9 i686)"
}

set bc_ver "v1.06"

if {!$bc_busy && ![string match *bc_doload* [utimers]]} {
  utimer 10 bc_doload
}

if {$bc_addchans} {
  channel add $bc_chatchan {
    idle-kick 0
  }
  channel set $bc_chatchan -clearbans -enforcebans -dynamicbans +userbans -autoop -bitch -greet -protectops -statuslog -stopnethack -revenge -autovoice +secret -cycle

  foreach bc_chan [split $bc_chans] {
    channel add $bc_chan {
      idle-kick 0
    }
    channel set $bc_chan -clearbans -enforcebans -dynamicbans +userbans -autoop -bitch -greet -protectops -statuslog -stopnethack -revenge -autovoice +secret -cycle
  }
}

if {![info exists bc_tmin]} {
  set bc_tmin [rand 60]
  if {[string length $bc_tmin] == 1} {
    set bc_tmin 0$bc_tmin
  }
}
if {![info exists bc_thour]} {
  set bc_thour [expr [rand 23] + 1]
  if {[string length $bc_thour] == 1} {
    set bc_thour 0$bc_thour
  }
}
bind time - "$bc_tmin $bc_thour * * *" bc_reset
bind time - "?6 * * * *" bc_chkchans
bind time - "?2 * * * *" bc_kickstart
bind join - * bc_join
bind pub - !click bc_addclick
bind pub - !click2 bc_addclick2
bind ctcp - !bcver bc_ctcp

putlog "*** Banner Clicker 1.06 successfully loaded."
